update tec_settings set version = '2.5.2';


CREATE 
    ALGORITHM = UNDEFINED
    SQL SECURITY DEFINER
VIEW `view_sales` AS
    SELECT 
        `tec_sales`.`id` AS `pid`,
        `tec_sales`.`date` AS `date`,
        `tec_sales`.`customer_name` AS `customer_name`,
        `tec_sales`.`currency` AS `currency`,
        `tec_sales`.`grand_total` AS `grand_total`,
        `tec_sales`.`paid` AS `paid`,
        `tec_sales`.`status` AS `status`,
        CASE
            WHEN `tec_sales`.`document_type` = 1 THEN 'Boleta'
            WHEN `tec_sales`.`document_type` = 2 THEN 'Factura'
            ELSE 'Nota de venta'
        END AS `vdoctype`,
        `tec_sales`.`invoice_id` AS `ndoc`,
        `tec_sales`.`estado` AS `estado`,
        `tec_canals`.`canal` AS `canal`,
        IF(`t2`.`estadoSend` = 1,
            'Error de envío',
            IF(`t2`.`estadoSend` = 2,
                'Enviado',
                IF(`t2`.`estadoSend` = 3,
                    'Rechazado',
                    IF(`t2`.`estadoSend` = 4,
                        'Procesado',
                        '')))) AS `Name_exp_12`,
        `tec_locals`.`code` AS `code`,
        `tec_sales`.`created_by` AS `created_by`
    FROM
        (((`tec_sales`
        LEFT JOIN `tec_canals` ON (`tec_canals`.`id` = `tec_sales`.`canal_id`))
        LEFT JOIN `tec_locals` ON (`tec_locals`.`id` = `tec_sales`.`local_id`))
        LEFT JOIN (SELECT 
            `detalle`.`sale_id` AS `id_venta`,
                `envio`.`status` AS `estadoSend`
        FROM
            (`tec_send_invoice` `envio`
        JOIN `tec_send_invoice_items` `detalle` ON (`detalle`.`send_invoice_id` = `envio`.`id`))
        WHERE
            `envio`.`estado` = 1) `t2` ON (`t2`.`id_venta` = `tec_sales`.`id`))
    ORDER BY `tec_sales`.`date` DESC